/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oip.oipc.oipch.OipchSystem;
import oracle.sysman.oip.oipc.oipch.OipchSystemWriter;
import oracle.sysman.oip.oipc.oipch.OipchUnixBooleanMountParameter;
import oracle.sysman.oip.oipc.oipch.OipchUnixDevice;
import oracle.sysman.oip.oipc.oipch.OipchUnixGroup;
import oracle.sysman.oip.oipc.oipch.OipchUnixNumberMountParameter;
import oracle.sysman.oip.oipc.oipch.OipchUnixPartition;
import oracle.sysman.oip.oipc.oipch.OipchUnixStringMountParameter;
import oracle.sysman.oip.oipc.oipch.OipchUnixUser;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;

public class OipchLinuxSystemWriter
extends OipchSystemWriter {
    XMLElement getPartitionsDetails(OipchSystem oSys) {
        XMLElement xmlPartitions = new XMLElement("PARTITIONS");
        Iterator oPartitions = oSys.getPartitionDetails();
        if (oPartitions != null) {
            while (oPartitions.hasNext()) {
                OipchUnixPartition oPartition;
                Object oPartitionsOb = oPartitions.next();
                if (!(oPartitionsOb instanceof OipchUnixPartition) || (oPartition = (OipchUnixPartition)oPartitionsOb) == null) continue;
                XMLElement xmlPartition = new XMLElement("PARTITION");
                xmlPartition.setAttribute("DEVICE", oPartition.getDevice());
                xmlPartition.setAttribute("MOUNT", oPartition.getMount());
                xmlPartition.setAttribute("TYPE", oPartition.getType());
                xmlPartition.setAttribute("PARAMS", this.constructParamString(oPartition));
                xmlPartitions.appendChild((Node)xmlPartition);
            }
        }
        return xmlPartitions;
    }

    private String constructParamString(OipchUnixPartition oPartition) {
        List oParams = oPartition.getParams();
        String sParamStr = null;
        if (oParams != null) {
            sParamStr = "";
            for (int i = 0; i < oParams.size(); ++i) {
                Object oParam = oParams.get(i);
                if (oParam instanceof OipchUnixStringMountParameter) {
                    OipchUnixStringMountParameter oStrParam = (OipchUnixStringMountParameter)oParam;
                    sParamStr = sParamStr + oStrParam.getName();
                    sParamStr = sParamStr + "=";
                    sParamStr = sParamStr + (String)oStrParam.getValue();
                } else if (oParam instanceof OipchUnixNumberMountParameter) {
                    OipchUnixNumberMountParameter oNumParam = (OipchUnixNumberMountParameter)oParam;
                    sParamStr = sParamStr + oNumParam.getName();
                    sParamStr = sParamStr + "=";
                    sParamStr = sParamStr + (Long)oNumParam.getValue();
                } else if (oParam instanceof OipchUnixBooleanMountParameter) {
                    OipchUnixBooleanMountParameter oBoolParam = (OipchUnixBooleanMountParameter)oParam;
                    sParamStr = sParamStr + oBoolParam.getName();
                }
                if (i == oParams.size() - 1) continue;
                sParamStr = sParamStr + ",";
            }
        }
        return sParamStr;
    }

    XMLElement getUserGrpDetails(OipchSystem oSys) {
        Iterator oGrps;
        XMLElement xmlUG = new XMLElement("USERS_GROUPS");
        Iterator oUsers = oSys.getUsers();
        if (oUsers != null) {
            while (oUsers.hasNext()) {
                OipchUnixUser oUser;
                Object oUserOb = oUsers.next();
                if (!(oUserOb instanceof OipchUnixUser) || (oUser = (OipchUnixUser)oUserOb) == null) continue;
                XMLElement xmlUser = new XMLElement("USER");
                OiisVariableOwner oCtxt = null;
                xmlUser.setAttribute("VALUE", oUser.getUserName(oCtxt));
                OipchUnixGroup activeGroup = oUser.getActiveGroup();
                if (activeGroup != null) {
                    xmlUser.setAttribute("ACTIVEGROUP", activeGroup.getName(oCtxt));
                }
                try {
                    Integer oID = new Integer(oUser.getID());
                    xmlUser.setAttribute("ID", oID.toString());
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                Iterator oUsrGrps = oUser.getGroups().iterator();
                if (oUsrGrps != null) {
                    while (oUsrGrps.hasNext()) {
                        xmlUser.appendChild((Node)this.getGroup(oUsrGrps.next()));
                    }
                }
                xmlUG.appendChild((Node)xmlUser);
            }
        }
        if ((oGrps = oSys.getGroups()) != null) {
            while (oGrps.hasNext()) {
                xmlUG.appendChild((Node)this.getGroup(oGrps.next()));
            }
        }
        return xmlUG;
    }

    private XMLElement getGroup(Object ob) {
        XMLElement xmlGrp = null;
        if (ob instanceof OipchUnixGroup) {
            OipchUnixGroup oGrp = (OipchUnixGroup)ob;
            xmlGrp = new XMLElement("GROUP");
            OiisVariableOwner oCtxt = null;
            xmlGrp.setAttribute("VALUE", oGrp.getName(oCtxt));
            try {
                Integer oID = new Integer(oGrp.getID());
                xmlGrp.setAttribute("ID", oID.toString());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return xmlGrp;
    }

    XMLElement getDevicesDetails(OipchSystem oSys) {
        Set oKeyset;
        XMLElement xmlDevices = new XMLElement("DEVICES");
        Map oDevices = oSys.getDeviceDetails();
        if (oDevices != null && !oDevices.isEmpty() && (oKeyset = oDevices.keySet()) != null) {
            Iterator oKeys = oKeyset.iterator();
            while (oKeys.hasNext()) {
                Long oAvail;
                OipchUnixDevice oDevice;
                String sKey = (String)oKeys.next();
                Object oDevicesOb = oDevices.get(sKey);
                if (!(oDevicesOb instanceof OipchUnixDevice) || (oDevice = (OipchUnixDevice)oDevicesOb) == null) continue;
                XMLElement xmlDevice = new XMLElement("DEVICE");
                xmlDevice.setAttribute("NAME", oDevice.getName());
                xmlDevice.setAttribute("MOUNT", oDevice.getMount());
                xmlDevice.setAttribute("PERMS", oDevice.getPermissions());
                xmlDevice.setAttribute("USER", oDevice.getUser());
                xmlDevice.setAttribute("GROUP", oDevice.getGroup());
                Long oTotal = oDevice.getTotalMem();
                if (oTotal != null) {
                    xmlDevice.setAttribute("TOTAL", oTotal.toString());
                }
                if ((oAvail = oDevice.getAvailMem()) != null) {
                    xmlDevice.setAttribute("AVAILABLE", oAvail.toString());
                }
                if (oDevice.isASMCandidate()) {
                    xmlDevice.setAttribute("ASM_CANDIDATE", "TRUE");
                }
                if (oDevice.isASMStamped()) {
                    xmlDevice.setAttribute("ASM_STAMPED", "TRUE");
                }
                xmlDevices.appendChild((Node)xmlDevice);
            }
        }
        return xmlDevices;
    }
}

